



import pandas as pd
import os 
import glob
import openpyxl

# find the current working directory 
path = os.getcwd() 

#make a list of all manipulated TOFs
tof_files = glob.glob(os.path.join(path, "*11.TOF")) 

if len(tof_files)>0:
    #create a dummy df that have indexes like first TOF file
    one_tof = pd.read_table(tof_files[0],header=0, skiprows=11, names=[tof_files[0]])
    all_man_tofs = pd.DataFrame(index=one_tof.index)
    
    #loop for all TOFs in the list
    for tof in tof_files:
        short_name = tof.removeprefix(path).removeprefix('\\').removesuffix('.TOF') #short name for the df table header
        one_tof = pd.read_table(tof,header=0, skiprows=11, names=[short_name]) #read a file
        all_man_tofs = all_man_tofs.join(one_tof) #join the readed file to a data frame
    
    #all_man_tofs.to_csv(os.getcwd()+'\\all_man_data.csv', index=False)
    all_man_tofs.to_excel(os.getcwd()+'\\all_man_data.xlsx', index=False)

# Raw Data - all the same as above only diff is the pattern of the file name - 10.TOF

path = os.getcwd() 
tof_files = glob.glob(os.path.join(path, "*10.TOF")) 

if len(tof_files)>0:

    one_tof = pd.read_table(tof_files[0],header=0, skiprows=11, names=[tof_files[0]])
    all_tofs = pd.DataFrame(index=one_tof.index)
    
    for tof in tof_files:
        short_name = tof.removeprefix(path).removeprefix('\\').removesuffix('.TOF')
        one_tof = pd.read_table(tof,header=0, skiprows=11, names=[short_name])
        all_tofs = all_tofs.join(one_tof)
    
    
    #all_tofs.to_csv(os.getcwd()+'\\all_raw_data.csv', index=False)
    all_tofs.to_excel(os.getcwd()+'\\all_raw_data.xlsx', index=False)

#write all files in one excel with two data_sheetes
#with pd.ExcelWriter('all_data.xlsx') as writer: 
#    all_man_tofs.to_excel(writer, sheet_name='man', index=False)
#    all_tofs.to_excel(writer, sheet_name='raw', index=False)

print('Your files saved in '+os.getcwd())